﻿using System.ServiceProcess;
using System.Windows;

namespace MoneyServerController
{
    /// <summary>
    /// Uruchamianie i zatrzymywanie usługi
    /// </summary>
    public partial class Window1 : Window
    {
        private ServiceController m_moneyCtrl;

        public Window1()
        {
            InitializeComponent();

            m_moneyCtrl = new ServiceController
            {
                ServiceName = "Service1"
            };
        }

        private void btnStart_Click(object sender, RoutedEventArgs e)
        {
            m_moneyCtrl.Refresh();
            if (m_moneyCtrl.Status == 
                ServiceControllerStatus.Stopped)
            {
                m_moneyCtrl.Start();
            }
        }

        private void btnStop_Click(object sender, RoutedEventArgs e)
        {
            m_moneyCtrl.Refresh();
            if (m_moneyCtrl.Status == 
                ServiceControllerStatus.Running)
            {
                m_moneyCtrl.Stop();
            }
        }
    }
}
